plugin material heaven_sea
name:"Heaven Ocean"
classID:#(0x953f95a, 0x7bb1cf23)
extends:standard
replaceUi:true
(
parameters main rollout:params
(
underwtr type:#color default:(color 60 87 80) ui:underw
supersp type:#boolean default:false ui:superqual
glit type:#float default:150 ui:specul
crisp type:#integer default:9 ui:crispy
whip type:#integer default:5 ui:whipped
viewdepth type:#integer default:200 ui:viewd
siz type:#float default:500 ui:sized
top type:#color default:white
dwn type:#color default:black
ani type:#time
on ani set val do
(
set animate on
set time 0f
delegate.displacementmap.phase=0
delegate.displacementmap.coords.offset=[0,0,0]
delegate.bumpmap.phase=0
delegate.bumpmap.coords.offset=[0,0,0]

set time 10000f
delegate.displacementmap.phase=100
delegate.displacementmap.coords.offset=[-20000,0,0]
delegate.bumpmap.phase=100
delegate.bumpmap.coords.offset=[-10000,0,0]
set animate off
delegate.displacementmap.phase.keys[1].inTangentType=#linear
delegate.displacementmap.phase.keys[1].outTangentType=#linear

delegate.displacementmap.phase.keys[2].inTangentType=#linear
delegate.displacementmap.phase.keys[2].outTangentType=#linear

delegate.displacementmap.coords.offset.keys[1].inTangentType=#linear
delegate.displacementmap.coords.offset.keys[1].outTangentType=#linear

delegate.displacementmap.coords.offset.keys[2].inTangentType=#linear
delegate.displacementmap.coords.offset.keys[2].outTangentType=#linear

delegate.bumpmap.phase.keys[1].inTangentType=#linear
delegate.bumpmap.phase.keys[1].outTangentType=#linear

delegate.bumpmap.phase.keys[2].inTangentType=#linear
delegate.bumpmap.phase.keys[2].outTangentType=#linear

delegate.bumpmap.coords.offset.keys[1].inTangentType=#linear
delegate.bumpmap.coords.offset.keys[1].outTangentType=#linear

delegate.bumpmap.coords.offset.keys[2].inTangentType=#linear
delegate.bumpmap.coords.offset.keys[2].outTangentType=#linear

)
on top set val do delegate.displacementmap.color1=val
on dwn set val do delegate.displacementmap.color2=val
on siz set val do delegate.displacementMap.size=val
on viewdepth set val do 
(
delegate.refractionmap.parameters.color_density_end=val
delegate.refractionmap.parameters.fog_end=val*1.5
)
on underwtr set val do delegate.diffuse=val
on supersp set val do delegate.samplerenable=val
on glit set val do
(
delegate.refractionmap.parameters.fog_amount=1-(val/300)
delegate.specularLevel=val
delegate.glossiness=(val/10)+40
delegate.refractionmapamount=(val/3.5)
)
on crisp set val do
(
delegate.displacementMapamount=val
)
on whip set val do
(
delegate.bumpmapamount=val
)
)--end params
rollout params "Ocean Parameters:"
(
group"Water Properties:"
(
checkbox superqual "Antialias" width:110  pos:[20,40] checked:off
colorpicker underw "Underwater Color" width:110 heigth:44 pos:[20,70] enabled:true
dropdownlist Substances "By Substance" items:#("Algae","Cooper","Ferrous","Limesto","Marine","Mud")selection:5 width:100 heigth:44 pos:[20,90]
slider viewd "Dense                  Light" orient:#horizontal ticks:10 range:[25,250,200] width:110 heigth:44 pos:[190,30]
slider specul "Muddy          Crystalline" orient:#horizontal ticks:10 range:[10,300,150] width:110 heigth:44 pos:[190,100]

)
group"Physical Properties"
(
checkbox threedim "3D Ocean" width:110  pos:[20,190] checked:on
slider crispy "Lake                 Ocean" orient:#horizontal ticks:10 range:[2,18,9] width:110 heigth:44 pos:[20,220]
slider whipped "Calm              Whipped" orient:#horizontal ticks:10 range:[0,10,5] width:110 heigth:44 pos:[190,220]
dropdownlist blobby "Wave Type" items:#("Choppy","Blobby") selection:1 width:100 heigth:44 pos:[20,290]
slider sized "Pool             Seascape" orient:#horizontal ticks:10 range:[200,800,500] width:110 heigth:44 pos:[190,290]
)
group"Atmosphere"
(
)
on threedim changed state do
	(
	local threex
	if state then threex = true else threex = false
	delegate.displacementmapenable = threex
	if threex == true then
		(
		crispy.enabled = true
		)
		else
		(
		crispy.enabled = false
		)
)

on crispy changed val do
(
delegate.displacementMapamount=val
)


on params open do
(
if delegate.displacementmapenable == true then threedim.checked = true else threedim.checked = false

if threedim.checked then
		(
		crispy.enabled = true
		
		)
		else
		(
		crispy.enabled = false
		
		)


)


on substances selected i do
(
case i of
(
1:(
underwtr=(color 75 79 52)
)
2:(
underwtr=(color 102 116 151)
)
3:(
underwtr=(color 165 100 75)
)
4:(
underwtr=(color 191 189 169)
)
5:(
underwtr=(color 60 87 80)
)
6:(
underwtr=(color 87 80 60)
)
)
)
on blobby selected i do
(
case i of
(
1:(
top=white
dwn=black
)
2:(
top=black
dwn=white
)
)
)
)--end rollout


on create do 
(
delegate.useglobalsettings=off
delegate.refractionmap=raytrace()
delegate.refractionmap.parameters.color_density_enable=true
delegate.refractionmap.parameters.color_density_color=underwtr
delegate.refractionmap.parameters.color_density_amount=1
delegate.refractionmap.parameters.fog_enable=true
delegate.refractionmap.parameters.fog_color=underwtr
delegate.displacementMap=noise()
delegate.displacementMap.coords.coordtype=1
delegate.displacementMap.type=2
delegate.displacementmap.levels=6
delegate.displacementmap.thresholdhigh=0.65

delegate.bumpMap=noise()
delegate.bumpmap.coords.coordtype=1
delegate.bumpmap.type=2
delegate.bumpMap.size=40
delegate.bumpMap.thresholdhigh=0.8
delegate.bumpmap.levels=4
delegate.bumpmap.color1=black
delegate.bumpMap.color2=white

)
)--end plugin